#!/bin/bash

################################################################################################
# dvdformat.sh
#
# Usage: dvdformat.sh <device file> <log file> <label>
#
# Label: The optional volume id for the DVD-RAM media
#
# Return Codes:
# 1 - Error formating the dvd media
#
# Module History
#  00  05/10/02  D. Deamond - Initial Release
#  01  07/12/02  P. Provost - Changed to use mkudffs instead of mkudf
#  02  07/18/02  P. Provost - Changed script to use device file argument
#  03  12/03/03  P. Provost - Removed params --udrev=0x0150 --media-type=dvdram --blocksize=2048
#  04  01/14/03  P. Provost - Put --udfrev=0x0150 back in because of problems with default value
#  05  12/14/04  P. Provost - Removed the --lvid option, use only the --vid option for label
#  06  12/15/04  P. Provost - Put quotes around $LABEL in case the given label contains spaces
################################################################################################

DEVICEFILE=$1
LOGFILE=$2
LABEL=$3

echo "-> dvdformat.sh" >> $LOGFILE
echo "Formatting the DVD-RAM at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> dvdformat.sh"
actzTrace "XMDA   F: dvdformat.sh: Formatting the DVD-RAM at $DEVICEFILE for `date`"

# Check to see if label argument exists
if [ -z "$LABEL" ]
then
    # Format the DVD-RAM media with no label
    echo "Formatting the DVD-RAM media without a label." >> $LOGFILE
    actzTrace "XMDA   F: dvdformat.sh: Formatting the Formatting the DVD-RAM media without a label."
    
    if ! mkudffs --udfrev=0x0150 $DEVICEFILE >> $LOGFILE 2>&1; then
        echo "Couldn't format the DVD-RAM media...exiting" >> $LOGFILE
        actzTrace "XMDA   F: dvdformat.sh: Couldn't format the DVD-RAM media...exiting"
        exit 1
    fi
else        
    # Format the DVD-RAM media with the given label
    echo "Formatting the DVD-RAM with the label: $LABEL" >> $LOGFILE
    actzTrace "XMDA   F: dvdformat.sh: Formatting the DVD-RAM with the label: $LABEL" 
    
    if ! mkudffs --udfrev=0x0150 --vid="$LABEL" $DEVICEFILE >> $LOGFILE 2>&1; then  
        echo "Couldn't format the DVD-RAM media...exiting" >> $LOGFILE
        actzTrace "XMDA   F: dvdformat.sh: Couldn't format the DVD-RAM media...exiting"
        exit 1
    fi
fi

actzTrace "XMDA   T: <- dvdformat.sh"

echo "<- dvdformat.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0


